/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;
import java.io.Serializable;

public class TimeBase
implements Serializable,
Storable {
    public static final transient int TIME_BASE_MS = 5;
    public static final transient int TIME_BASE_10MS = 0;
    public static final transient int TIME_BASE_S = 1;
    public static final transient int TIME_BASE_M = 2;
    public static final transient int TIME_BASE_H = 3;
    public static final transient int TIME_BASE_D = 4;
    private static final long serialVersionUID = 1733907228680449298L;
    private int fTimeBaseKey;
    private int fTime;

    public TimeBase() {
        this.fTimeBaseKey = 2;
    }

    public TimeBase(int timeBase) {
        this.fTimeBaseKey = timeBase;
    }

    public TimeBase(int timeBase, int time) {
        this.fTimeBaseKey = timeBase;
        this.fTime = time;
    }

    public String getTimeBaseContent() {
        return TimeBase.getOutputTimeBase(this.fTimeBaseKey);
    }

    public String getTimeBaseAbbreviation() {
        switch (this.fTimeBaseKey) {
            case 4: {
                return "d";
            }
            case 3: {
                return "h";
            }
            case 2: {
                return "m";
            }
            case 1: {
                return "s";
            }
            case 0: {
                return "ms";
            }
        }
        return "?";
    }

    public int getTimeBaseKey() {
        return this.fTimeBaseKey;
    }

    public void setTimeBaseKey(int timeBaseKey) {
        this.fTimeBaseKey = timeBaseKey;
    }

    public int getTime() {
        return this.fTime;
    }

    public void setTime(int time) {
        this.fTime = time;
    }

    public String toString() {
        return this.getTimeBaseContent();
    }

    public void read(StorableInput dr) throws IOException {
        this.fTimeBaseKey = dr.readInt();
        this.fTime = dr.readInt();
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.fTimeBaseKey);
        dw.writeInt(this.fTime);
    }

    public static String getOutputTimeBase(int timeBase) {
        switch (timeBase) {
            case 4: {
                return Language.getString("dialog.parameter.timebase.day", "Day");
            }
            case 3: {
                return Language.getString("dialog.parameter.timebase.hours", "Hour");
            }
            case 2: {
                return Language.getString("dialog.parameter.timebase.minutes", "Minute");
            }
            case 1: {
                return Language.getString("dialog.parameter.timebase.seconds", "Second");
            }
            case 0: {
                return Language.getString("dialog.parameter.timebase.decamilliseconds", "10 milliseconds");
            }
        }
        return "?";
    }

    public String formatTime(long time) {
        long high = 0L;
        long low = 0L;
        switch (this.fTimeBaseKey) {
            case 3: {
                high = time / 3600000L;
                low = time / 60000L % 60L;
                break;
            }
            case 2: {
                high = time / 60000L;
                low = time / 1000L % 60L;
                break;
            }
            case 1: {
                high = time / 1000L;
                low = time % 1000L / 10L;
                break;
            }
            case 0: {
                return String.valueOf(time / 10L) + " " + this.getTimeBaseAbbreviation();
            }
        }
        return Util.addLeadingZeros(String.valueOf(high), 2) + ":" + Util.addLeadingZeros(String.valueOf(low), 2) + this.getTimeBaseAbbreviation();
    }

    public static String formatTime(long time, int timeBase) {
        if (time < 0L) {
            return "###########";
        }
        long[] times = null;
        switch (timeBase) {
            case 3: {
                times = new long[]{time};
                break;
            }
            case 2: {
                times = new long[]{time / 60L, time % 60L};
                break;
            }
            case 1: {
                times = new long[]{time / 3600L, time / 60L % 60L, time % 60L};
                break;
            }
            case 0: {
                times = new long[]{time / 360000L, time / 6000L % 60L, time / 100L % 60L, time % 100L};
            }
        }
        if (times == null || times.length == 0) {
            return "";
        }
        StringBuffer formated = new StringBuffer(Util.addLeadingZeros(String.valueOf(times[0]), 2));
        for (int i = 1; i < times.length; ++i) {
            if (timeBase == 0 && i == times.length - 1) {
                formated.append(".");
            } else {
                formated.append(":");
            }
            formated.append(Util.addLeadingZeros(String.valueOf(times[i]), 2));
        }
        return formated.toString();
    }

    public long getTimeValueByBase(long time) {
        switch (this.fTimeBaseKey) {
            case 3: {
                return time / 3600000L;
            }
            case 2: {
                return time / 60000L;
            }
            case 1: {
                return time / 1000L;
            }
            case 0: {
                return time / 10L;
            }
        }
        return 0L;
    }

    public static TimeBase[] getDefaultTimeBases() {
        return new TimeBase[]{new TimeBase(3), new TimeBase(2), new TimeBase(1), new TimeBase(0)};
    }
}

